#ifndef _Command_CPP
#define _Command_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/SQLClass/cSQL.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLExport.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SendFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sRecvBuf, int iRecvBufSz);

	Processes a command from the peer.

	Possible return Values:
		CMD_OK    The command was a success, all is well.
		CMD_DONE  The command was a success, close the connection.
		CMD_ERROR The command failed due to an error.
*/
int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[IDEAL_RECV_SIZE + 1];
    char sSendBuf[IDEAL_SEND_SIZE + 1];
	char sTemp[1024];

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Ping")))
    {
		pSockSrvr->SetNextSendData(iClient, "::Pong");
		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Pong")))
    {
		//WriteLog(pSockSrvr->icClientID[iClient], "Received ping reply.");
		pSockSrvr->SetNextSendData(iClient, "::Ping");
		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::ImportTable->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		//WriteLog(pSockSrvr->icClientID[iClient], "Received import table.");

		strcpy(CCI.sImportTable, sCmdData);
		CCI.bGotImportTable = true;

		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Msg->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sCmdData);
		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::SQL->")))
    {
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		//WriteLog(pSockSrvr->icClientID[iClient], "Received SQL string.");

		if(CCI.bGotImportTable)
		{
			CCI.bGotImportTable = false;

			int iSQLExpRes = ExportSQLResults(pSockSrvr, iClient, sCmdData, sExportFileTemp);
			if(iSQLExpRes == SQL_IMPORT_RESULT_ZEROROWS)
			{
				//The statement was is supposed to return data, it didnt... Thats ok!
				//Request the next statement.
				pSockSrvr->SetNextSendData(iClient, "::SendNextSQL");
				return CMD_OK;
			}
			else if(iSQLExpRes == SQL_IMPORT_RESULT_OK){
	            //sprintf(FlaggedData, "::FileSize:%d", Get_FileSize(gsSQLExportTempFile));
				//SimpleClientSend(FlaggedData);

	            sprintf(sSendBuf, "::SendingFileData->%s", CCI.sImportTable);
				pSockSrvr->SetNextSendData(iClient, sSendBuf);

				SendFileData(pSockSrvr, iClient, sExportFileTemp);
				return CMD_OK;
			}
			else if(iSQLExpRes == SQL_IMPORT_RESULT_ERROR){
	            // There was an error exporting the SQL data.
				// FIXME: What do we do now, Request the next statement or disconnect?
				return CMD_ERROR;
			}
		}
		else{
			//The statement was not a statement that is supposed to return data.
			//Request the next statement.

			CRecordSet rsTemp;

			if(!CCI.cCustSQL.Execute(sCmdData, &rsTemp))
			{
				sprintf(sTemp, "Execute: Fail on (%s)", sCmdData);
				WriteLog(pSockSrvr->icClientID[iClient], sTemp);
				return CMD_ERROR;
			}

			sprintf(sTemp, "Statement affected %d rows.", rsTemp.RowCount);
			WriteLog(pSockSrvr->icClientID[iClient], sTemp);

			rsTemp.Close();

			pSockSrvr->SetNextSendData(iClient, "::SendNextSQL");
			return CMD_OK;
		}

		WriteLog(pSockSrvr->icClientID[iClient], "Logic failed. Should never get here.");
		return CMD_ERROR;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::EndOfStatements")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");

		return CMD_DONE;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::LastImportSuccess")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Last import was a Success.");

		//The last import succeeded. If we need to take action then this is where to do it.
		//---------------------------------------------------------------------------------
/*
		CRecordSet rsTemp;

		sprintf(sTemp, "update %s set Portal_Dirty = 0 where Portal_Dirty = 3", CCI.sImportTable);
		if(!CCI.cCustSQL.Execute(sTemp, &rsTemp))
		{
			sprintf(sTemp, "Execute: Fail on (%s)", sTemp);
			WriteLog(pSockSrvr->icClientID[iClient], sTemp);
			return CMD_ERROR;
		}

		sprintf(sTemp, "Cleared %d rows.", rsTemp.RowCount);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

		rsTemp.Close();
*/
		pSockSrvr->SetNextSendData(iClient, "::SendNextSQL");
		return CMD_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::LastImportFailed")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Last import failed.");

		//The last import failed. If we need to take action then this is where to do it.
		//------------------------------------------------------------------------------
		/*
		CRecordSet rsTemp;

		sprintf(sTemp, "update %s set Portal_Dirty = 1 where Portal_Dirty = 3", CCI.sImportTable);
		if(!CCI.cCustSQL.Execute(sTemp, &rsTemp))
		{
			sprintf(sTemp, "Execute: Fail on (%s)", sCmdData);
			WriteLog(pSockSrvr->icClientID[iClient], sTemp);
			return CMD_ERROR;
		}

		sprintf(sTemp, "Reset %d rows.", rsTemp.RowCount);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

		rsTemp.Close();
		*/

		pSockSrvr->SetNextSendData(iClient, "::SendNextSQL");
		return CMD_OK;
	}

	WriteLog(pSockSrvr->icClientID[iClient], "Received unknown command.");
	return CMD_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SendFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName)
{
    FILE *hSourceHandle = NULL;

    char sFileBuffer[FILEBUFFERSZ + 1];
	int iBytesRead = 0;

    DWORD dwDataCRC = 0xffffffff;

	WriteLog(pSockSrvr->icClientID[iClient], "Begining file transfer.");

	if( (hSourceHandle = fopen(sFileName, "rb")) == NULL)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Failed to open export file for binary read.");
        return false;
    }

    do{
        //if(MyClient.PeekSizeOfSendData() == 0)
        //{
            iBytesRead = fread(sFileBuffer, sizeof(char), FILEBUFFERSZ, hSourceHandle);
            dwDataCRC = PartialCRC(dwDataCRC, sFileBuffer, iBytesRead);
            pSockSrvr->SetNextSendDataEx(iClient, sFileBuffer, iBytesRead);
        //}
        //else Sleep(1);
    } while(iBytesRead == FILEBUFFERSZ && pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient]);

	fclose(hSourceHandle);

	if(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		pSockSrvr->SetNextSendData(iClient, "::EOF");
		return true;
	}
	else return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
